<?php
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/helpers.php';

$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $full_name = $_POST['full_name'] ?? '';
  $address = $_POST['address'] ?? '';
  $phone = $_POST['phone'] ?? '';
  $email = $_POST['email'] ?? '';
  $nik = $_POST['nik'] ?? '';
  $package_id = $_POST['package_id'] ?? null;
  $city = $_POST['city'] ?? '';
  if (!$full_name) $errors[] = 'Nama lengkap wajib diisi';
  if (!$nik) $errors[] = 'NIK wajib diisi';
  if (empty($errors)) {
    $selfie = save_upload($_FILES['selfie'] ?? null, __DIR__ . '/uploads/', 'selfie_');
    $ktp = save_upload($_FILES['ktp'] ?? null, __DIR__ . '/uploads/', 'ktp_');
    $stmt = $pdo->prepare('INSERT INTO customers (full_name,address,phone,email,nik,selfie_path,ktp_path,package_id,city,status) VALUES (?,?,?,?,?,?,?,?,?,?)');
    $stmt->execute([$full_name,$address,$phone,$email,$nik,$selfie,$ktp,$package_id,$city,'waiting']);
    $success = true;
  }
}
$packages = $pdo->query('SELECT * FROM packages')->fetchAll();
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Pendaftaran</title></head><body>
<h1>Form Pendaftaran Pelanggan</h1>
<?php if(!empty($errors)){ echo '<ul>'; foreach($errors as $e) echo '<li>'.htmlspecialchars($e).'</li>'; echo '</ul>'; } ?>
<?php if(!empty($success)){ echo '<p style="color:green">Pendaftaran berhasil, tunggu approval supervisor.</p>'; } ?>
<form method="post" enctype="multipart/form-data">
  <label>Nama lengkap: <input name="full_name"></label><br>
  <label>Alamat: <textarea name="address"></textarea></label><br>
  <label>Kota: <input name="city"></label><br>
  <label>Phone: <input name="phone"></label><br>
  <label>Email: <input name="email" type="email"></label><br>
  <label>NIK: <input name="nik"></label><br>
  <label>Selfie (jpg/png): <input name="selfie" type="file"></label><br>
  <label>Foto KTP (jpg/png): <input name="ktp" type="file"></label><br>
  <label>Paket: <select name="package_id"><option value="">--Pilih--</option><?php foreach($packages as $p){ echo '<option value="'.(int)$p['id'].'">'.htmlspecialchars($p['name']).'</option>'; } ?></select></label><br>
  <button>Daftar</button>
</form>
</body></html>
